<?php

namespace App\Http\Controllers;

use App\Http\Requests\PaymentPORequest;
use App\Services\POService;
use Carbon\Carbon;
use Illuminate\Http\Request;

class ArController extends Controller
{
    public function __construct(
        private POService $po_service
    ) {
        $this->po_service = $po_service;
    }

    public function index()
    {
        $start = Carbon::now()->toDateString();
        $end   = Carbon::now()->addDays(7)->toDateString();

        return responseSuccessPaginate($this->po_service->get_ar([
            'start_due_date' => $start,
            'end_due_date'   => $end
        ]), 200, [
            'start_date' => translatedFormat($start, 'd/m/Y'),
            'end_date'   => translatedFormat($end, 'd/m/Y'),
        ]);
    }

    public function payment(PaymentPORequest $request)
    {
        $this->po_service->payment($request);

        return responseSuccess();
    }
}
