<?php

namespace App\Http\Controllers;

use App\Models\Configuration;
use App\Models\CostItem;
use App\Models\POItem;
use App\Models\ShoppingItem;
use App\Models\User;
use App\Services\UserService;
use Carbon\Carbon;
use Illuminate\Http\Request;

class CooperationStatusController extends Controller
{
    public function __construct(
        private UserService $user_service
    ) {
        $this->user_service = $user_service;
    }
    public function index()
    {
        $user = auth()->user();

        $now = Carbon::now();

        $conf = Configuration::first();

        $benefit = $this->user_service->total_benefit($user->id);

        return responseSuccess([ "data" =>[
            'active_period'     => $user->role == 'Mitra Mandiri' ? ($user->subs?->expired_at <> '' ? Carbon::parse($user->subs?->expired_at)->diff($now)->format('%y Tahun %m Bulan %d Hari') : null) : 'Unlimited',
            'active_until_at'   => $user->approved?->until <> '' ? translatedFormat($user->approved?->until, 'd F Y') : null,
            'pks'               => ValidateIsFile($conf->pks),
            'schema'            => $user->role == 'Mitra Kerjasama' ? ucwords(str_replace('_', ' ', $user->saldo?->skema)) : '-',
            'share_portion'     => $benefit['share_portion'] ?? 0,
            'total_modal_setor' => $benefit['total_modal_setor'] ?? 0,
            'total_biaya_modal' => $benefit['total_biaya_modal'] ?? 0,
            'total_benefit'     => $benefit['total_benefit'] ?? 0,
        ]]);
    }

    
}
