<?php

namespace App\Http\Controllers;

use App\Http\Requests\CustomerRequest;
use App\Http\Requests\CustomerUpdateRequest;
use App\Http\Resources\CustomerResource;
use App\Services\CustomerService;
use Illuminate\Http\Request;

class CustomerController extends Controller
{
    public function __construct(
        private CustomerService $cust_service
    ) {
        $this->cust_service = $cust_service;
    }

    public function create(CustomerRequest $request)
    {
        $this->cust_service->create($request);

        return responseSuccess();
    }

    public function update(CustomerUpdateRequest $request)
    {
        $this->cust_service->update($request);

        return responseSuccess();
    }

    public function index(Request $request)
    {
        return responseSuccessPaginate($this->cust_service->list($request));
    }

    public function detail($id)
    {
        return responseSuccess(['data' => new CustomerResource($this->cust_service->find($id))]);
    }

    public function delete($id)
    {
        $this->cust_service->delete($id);

        return responseSuccess();
    }
}
