<?php

namespace App\Http\Controllers;

use App\Models\Cost;
use App\Models\CostItem;
use App\Models\Customer;
use App\Models\NotificationUser;
use App\Models\PO;
use App\Models\POItem;
use App\Models\Product;
use App\Models\Shopping;
use App\Models\ShoppingItem;
use App\Models\TransactionSubscription;
use App\Models\Vendor;
use App\Services\UserService;
use Carbon\Carbon;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function __construct(
        private UserService $user_service
    ) {
        $this->user_service = $user_service;
    }
    public function index()
    {
        $user = auth()->user();

        $benefit = $this->user_service->total_benefit($user->id);

        $now = Carbon::now()->toDateString();

        $_isSubs = $user->subs ? (($user->subs?->expired_at >= $now) ? true : false): false;

        $_transSubs = TransactionSubscription::withParameters([
            'id_user' => $user->id,
            'status'  => 'waiting'
        ])->first();

        return responseSuccess(['data' => [
            'role'            => $user->role,
            'name_bussines'   => $user->business?->name_bussines,
            'profession'      => $user->profession?->title,
            // 'is_verified'     => $user->is_verified,
            'is_verified'     => $_isSubs,
            'is_subs'         => $_isSubs,
            'is_trans_subs_waiting' => $_transSubs ? true : false,
            'total_not_read'  => NotificationUser::where('user_id', $user->id)->where('is_read', 0)->count(),
            'total_balance'   => $user->role == 'Mitra Kerjasama' ? $user->saldo?->saldo : ($benefit['total_benefit'] ?? 0),
        ]]);
    }

    public function inventory()
    {
        $user = auth()->user();

        $_total_shop = ShoppingItem::withParameters(['id_user' => $user->id])->sum('subtotal');
        $_total_po   = POItem::withParameters(['id_user' => $user->id])->sum('subtotal');

        return responseSuccess(['data' => [
            'total_product'   => Product::withParameters(['id_user' => $user->id])->count(),
            'total_vendor'    => Vendor::withParameters(['id_user' => $user->id])->count(),
            'total_shopping'  => Shopping::withParameters(['id_user' => $user->id])->count(),
            'total_stock'     => ShoppingItem::withParameters(['id_user' => $user->id])->groupby('id_product')->count(),
            'total_inventory' => $_total_shop - $_total_po
        ]]);

    }

    public function sale()
    {
        $user = auth()->user();

        $start = Carbon::now()->toDateString();
        $end   = Carbon::now()->addDays(7)->toDateString();

        $start_month = Carbon::now()->firstOfMonth()->toDateString();
        $end_month   = Carbon::now()->endOfMonth()->toDateString();

        return responseSuccess(['data' => [
            'total_customer'   => Customer::withParameters(['id_user' => $user->id])->count(),
            'total_po'        => PO::withParameters(['id_user' => $user->id])->count(),
            'total_ar'        => PO::withParameters([
                'id_user'         => $user->id,
                'transaction_type'=> 'tempo',
                'is_payment'      => 'true',
                // 'start_due_date'  => $start,
                // 'end_due_date'    => $end
                ])->count(),
            'total_sale_count' => POItem::with(['po.customer'])
            ->withParameters([
                'id_user' => $user->id
            ])
            ->count(),
            'total_sale'      => POItem::withParameters([
                'id_user' => $user->id,
                'start_date'  => $start_month . ' 00:00:00',
                'end_date'    => $end_month . ' 23:59:59'
                ])->sum('subtotal'),
            'total_credit'      => POItem::withParameters([
                'id_user' => $user->id,
                'transaction_type'=> 'tempo',
                'is_payment'      => 'true',
                ])->sum('subtotal')
        ]]);

    }

    public function opex()
    {
        $user = auth()->user();

        $start_month = Carbon::now()->firstOfMonth()->toDateString();
        $end_month   = Carbon::now()->endOfMonth()->toDateString();

        return responseSuccess(['data' => [
            'total_cost'      => Cost::withParameters(['id_user' => $user->id])->count(),
            'total_cost_month'=> CostItem::with('cost')
                ->withParameters([
                'id_user' => $user->id,
                'start_date' => $start_month . ' 00:00:00',
                'end_date' => $end_month . ' 23:59:59',
                ])->sum('subtotal'),
        ]]);

    }
}
