<?php

namespace App\Http\Controllers;

use App\Services\NotifService;
use Illuminate\Http\Request;

class NotificationController extends Controller
{
    public function __construct(
        private NotifService $notif_service
    ) {
        $this->notif_service = $notif_service;
    }

    public function index()
    {
        return responseSuccessPaginate($this->notif_service->get());
    }

    public function read($id)
    {
        $this->notif_service->read_notif($id);

        return responseSuccess();
    }
}
