<?php

namespace App\Http\Controllers;

use App\Http\Requests\ShoppingRequest;
use App\Http\Requests\ShoppingUpdateRequest;
use App\Http\Resources\ShoppingResource;
use App\Services\ShoppingService;
use Illuminate\Http\Request;

class ShoppingController extends Controller
{
    public function __construct(
        private ShoppingService $shopping_service
    ) {
        $this->shopping_service = $shopping_service;
    }

    public function create(ShoppingRequest $request)
    {
        $this->shopping_service->create($request);

        return responseSuccess();
    }

    public function update(ShoppingUpdateRequest $request)
    {
        $this->shopping_service->update($request);

        return responseSuccess();
    }

    public function index(Request $request)
    {
        return responseSuccessPaginate($this->shopping_service->list($request));
    }

    public function detail($id)
    {
        return responseSuccess(['data' => new ShoppingResource($this->shopping_service->find($id))]);
    }

    public function delete($id)
    {
        $this->shopping_service->delete($id);

        return responseSuccess();
    }

    public function stock(Request $request)
    {
        return responseSuccessPaginate($this->shopping_service->stock($request));
    }
}
