<?php

namespace App\Http\Controllers;

use App\Http\Requests\SubscriptionCheckoutRequest;
use App\Http\Resources\TransactionSubscriptionResource;
use Illuminate\Http\Request;
use App\Models\Subscription;
use App\Models\TransactionSubscription;
use App\Services\SubscriptionService;
use Carbon\Carbon;

class SubscriptionController extends Controller
{
    public function __construct(
        private SubscriptionService $subcribe_service,
    ) {
        $this->subcribe_service = $subcribe_service;
    }

    public function index()
    {
        return responseSuccess([
            'data' => $this->subcribe_service->list()
        ]);
    }

    public function detail($id)
    {
        $find = $this->subcribe_service->find($id);

        
        if ($find) {
            $find->expired_at = Carbon::now()->addMonth($find->duration)->format('d/m/Y');    
        }
        return responseSuccess(['data' => $find ?? null]);
    }

    public function checkout(SubscriptionCheckoutRequest $request)
    {
        $store = $this->subcribe_service->checkout($request);

        return responseSuccess(['data' => $store]);
    }

    public function detail_transaction($id)
    {
        return responseSuccess(['data' => new TransactionSubscriptionResource($this->subcribe_service->find_transaction($id))]);
    }
}
