<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CostRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'purchase_date'  => 'required',
            'payment_method' => 'required',
            'upload_nota' => 'nullable',
            'upload_proof_of_payment' => 'nullable',
            'costs' => 'required|array',
            'costs.*.id_category' => 'required',
            'costs.*.title' => 'required',
            'costs.*.qty' => 'required',
            'costs.*.unit' => 'required',
            'costs.*.price' => 'required',
            'costs.*.subtotal' => 'required',
        ];
    }
}
