<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CostItemResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $show['id']          = $this->id;
        $show['id_category'] = $this->id_category;
        $show['category']    = $this->category?->title;
        $show['title']       = $this->title;
        $show['description'] = $this->description;
        $show['price']       = $this->subtotal / $this->qty;
        $show['qty']         = $this->qty;
        $show['unit']        = $this->unit;
        $show['subtotal']    = $this->subtotal;

        return $show;
    }
}
