<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class NotifyEmailReset extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        private $user
    ) {
        //
        $this->user = $user;
    }

    public function build()
    {
        return $this
            ->subject('Reset Password')
            ->view('email.reset', [
                'user' => $this->user
            ]);
    }
}
