<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Cost extends Model
{
use HasFactory, SoftDeletes;

    protected $table = 'op_pengeluaran';

    protected $fillable = [
        'id', 'id_user', 'purchase_date', 'payment_method', 'upload_nota', 'upload_proof_of_payment'
    ];

    protected $primaryKey = 'id';

    public $incrementing = false;

    protected $keyType = 'string';

    public function items()
    {
        return $this->hasMany(CostItem::class, 'id_op_pengeluaran', 'id');
    }

    public function scopeWithParameters($q, $request)
    {
        if (!empty($request['q'])) {
            
        }

        if (!empty($request['id_user'])) {
            $q->where('id_user', $request['id_user']);
        }

        if (!empty($request['start_date']) && !empty($request['end_date'])) {
            $q->whereBetween('created_at', [$request['start_date'], $request['end_date']]);
        }
    }
}
