<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CostItem extends Model
{
    use HasFactory;

    protected $table = 'op_pengeluaran_items';

    protected $fillable = [
        'id', 'id_op_pengeluaran', 'id_category', 'title', 'description', 'qty', 'unit', 'subtotal'
    ];

    protected $primaryKey = 'id';

    public $incrementing = false;

    protected $keyType = 'string';

    public function category()
    {
        return $this->belongsTo(Category::class, 'id_category')->where('type', 'pengeluaran');
    }

    public function cost()
    {
        return $this->belongsTo(Cost::class, 'id_op_pengeluaran');
    }

    public function scopeWithParameters($q, $request)
    {
        if (!empty($request['q'])) {
            
        }

        if (!empty($request['id_user'])) {
            $q->whereRelation('cost', 'id_user', $request['id_user']);
        }

        if (!empty($request['start_date']) && !empty($request['end_date'])) {
            $q->whereHas('cost', function($q) use ($request){
                $q->whereBetween('purchase_date', [$request['start_date'], $request['end_date']]);
            });
            
        } else if (!empty($request['start_date']) && empty($request['end_date'])){
            $q->whereHas('cost', function($q) use ($request){
                $q->where('purchase_date', 'like', $request['start_date'] . '%');
            });
            // $q->where('purchase_date', 'like', $request['start_date'] . '%');
        }

        if (!empty($request['id_category'])) {
            $q->where('id_category', $request['id_category']);
        }

    }
}
