<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Customer extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'customer';

    protected $fillable = [
        'id', 'id_user', 'name', 'pic', 'avatar', 'phone_number', 'position', 'contract'
    ];

    protected $primaryKey = 'id';

    public $incrementing = false;

    protected $keyType = 'string';

    public function address()
    {
        return $this->belongsTo(CustomerAddress::class, 'id', 'id');
    }

    public function scopeWithParameters($q, $request)
    {
        if (!empty($request['q'])) {
            $q->where('name','like','%'.$request['q'].'%');
        }

        if (!empty($request['id_user'])) {
            $q->where('id_user', $request['id_user']);
        }
    }
}
