<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomerAddress extends Model
{
    use HasFactory;

    protected $table = 'customer_address';

    protected $fillable = [
        'id', 'id_province', 'id_city', 'id_subdistrict', 'village', 'postcode', 'address', 'latitude', 'longitude',
        'rt', 'rw'
    ];

    protected $primaryKey = 'id';

    public $incrementing = false;

    protected $keyType = 'string';

    public function city()
    {
        return $this->belongsTo(City::class, 'id_city', 'city_id');
    }

    public function province()
    {
        return $this->belongsTo(Province::class, 'id_province', 'province_id');
    }

    public function subdistrict()
    {
        return $this->belongsTo(Subdistrict::class, 'id_subdistrict', 'subdistrict_id');
    }
}
