<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class POItem extends Model
{
    use HasFactory;

    protected $table = 'po_items';

    protected $fillable = [
        'id_po', 'id_product', 'product', 'qty', 'subtotal', 'description'
    ];

    protected $casts = [
        'product' => 'json'
    ];

    protected $primaryKey = 'id';

    public $incrementing = false;

    protected $keyType = 'string';

    public function po()
    {
        return $this->belongsTo(PO::class, 'id_po');
    }

    public function product()
    {
        return $this->belongsTo(Product::class, 'id_product');
    }

    public function scopeWithParameters($q, $request)
    {
        if (!empty($request['q'])) {
            
        }

        if (!empty($request['id_user'])) {
            $q->whereRelation('po', 'id_user', $request['id_user']);
        }

        if (!empty($request['payment_date'])) {
            $q->whereRelation('po', 'payment_date', $request['payment_date']);
        }

        if (!empty($request['is_payment']) && $request['is_payment'] == 'true') {
            $q->whereRelation('po', 'payment_date', null);
        }

        if (!empty($request['transaction_type'])) {
            $q->whereRelation('po', 'transaction_type', $request['transaction_type']);
        }

        if (!empty($request['start_due_date']) && !empty($request['end_due_date'])) {
            $q->whereHas('po', function($q) use($request){
                $q->whereBetween('due_date', [$request['start_due_date'], $request['end_due_date']]);
            });
        }

        if (!empty($request['start_date']) && !empty($request['end_date'])) {
            $q->whereBetween('created_at', [$request['start_date'], $request['end_date']]);
        }

        if (!empty($request['id_product'])) {
            $q->where('id_product', $request['id_product']);
        }

        if (!empty($request['purchase_date'])) {
            $q->whereRelation('po', 'purchase_date', $request['purchase_date']);
        }
    }
}
