<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'product';

    protected $fillable = [
        'id_user', 'id_category_product', 'title', 'id_unit_product', 'id_package_product', 'sku'
    ];

    public function category()
    {
        return $this->belongsTo(Category::class, 'id_category_product')->where('type', 'product')->withTrashed();
    }

    public function unit()
    {
        return $this->belongsTo(Unit::class, 'id_unit_product')->withTrashed();
    }

    public function package()
    {
        return $this->belongsTo(Package::class, 'id_package_product')->withTrashed();
    }

    public function scopeWithParameters($q, $request)
    {
        if (!empty($request['q'])) {
            $q->where('title','like','%'.$request['q'].'%');
        }

        if (!empty($request['id_user'])) {
            $q->where('id_user', $request['id_user']);
        }

        if (!empty($request['ids'])) {
            $q->whereIn('id', $request['ids']);
        }
    }
}
