<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserAccount extends Model
{
    use HasFactory;

    protected $table = 'user_account';

    protected $fillable = [
        'bank', 'branch', 'names', 'account_number', 'id'
    ];

    public function banks()
    {
        return $this->belongsTo(Bank::class, 'bank')->withTrashed();
    }
}
