<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserBussines extends Model
{
    use HasFactory;

    protected $table = 'user_bussines';

    protected $fillable = [
        'id', 'name_bussines', 'profile_bussines', 'id_province', 'id_city',
        'id_subdistrict', 'village', 'postcode', 'address', 'latitude', 'longitude',
        'status', 'verified', 'akta', 'npwp', 'nib', 'sk_kemenkum', 'rt', 'rw'
    ];

    public function city()
    {
        return $this->belongsTo(City::class, 'id_city', 'city_id');
    }

    public function province()
    {
        return $this->belongsTo(Province::class, 'id_province', 'province_id');
    }

    public function subdistrict()
    {
        return $this->belongsTo(Subdistrict::class, 'id_subdistrict', 'subdistrict_id');
    }
}
