<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VendorAccount extends Model
{
    use HasFactory;

    
    protected $table = 'vendor_account';
    
    protected $fillable = [
        'id', 'bank', 'branch', 'names', 'account_number'
    ];
    protected $primaryKey = 'id';

    public $incrementing = false;

    protected $keyType = 'string';

    public function banks()
    {
        return $this->belongsTo(Bank::class, 'bank')->withTrashed();
    }
}
