<?php

namespace App\Services;

use App\Models\{Notification, NotificationUser, TransactionSubscription};
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class NotifService
{
    public function __construct(
        private OneSignalService $one_signal_service
    ) {
    }

    public function store($type, $title, $description = "", $for = "all", $key = "")
    {
        DB::beginTransaction();

        $notif = Notification::create([
            "title"         => $title,
            "type"          => $type,
            "description"   => $description, 
            "key"           => $key
        ]);

        $this->create_notif_user($for, $notif->id);

        DB::commit();

        return true;
    }

    public function get()
    {
        $user = auth()->user();

        $data = NotificationUser::with(['notification'])->whereUserId($user->id);
        $data = $data->latest()->paginate(10);

        $data->getCollection()->transform(function ($item) {

            $notif = $item?->notification;

            $show['id']                 = $item->id;
            $show['type']               = $notif?->type;
            $show['title']              = $notif?->title;
            
            if ($show['type'] == 'subscribe') {
                $_key = $notif->key;
                
                $trans = TransactionSubscription::where('invoice_id', $_key['invoice_id'])->first();
                
                $show['description']        = "Status : " . $trans?->status;
                
            } else {
                $show['description']        = $notif?->description;
            }
            $show['key']                = $notif?->key;
            $show['is_read']    = $item->is_read > 0 ? true : false;
            $show['created_at'] = $notif?->created_at <> '' ? translatedFormat($notif?->created_at, 'd/m/Y') : null;

            return $show;
        });

        return $data;
    }

    public function read_notif($id)
    {
        $notif = NotificationUser::find($id);

        if ($notif) {

            $notif->update([
                "is_read" => 1
            ]);
        }

        return true;
    }

    public function deleteNotification($keyId, $type, $title = null){
        $paramsUsers = [
          'type' => $type,
          'key_id' => $keyId
        ];
        $find = Notification::where($paramsUsers);
        if ($title) {
          $find->where('title', 'LIKE', '%'.$title.'%');
        }
        $compile = $find;
        $compile = $compile->first();
    
        if ($compile) {
          $paramsNotification = [
            'notification_id' => $compile->id
          ];
    
          NotificationUser::where($paramsNotification)->delete();
    
          $compile->delete();
          
        }
    
      }

    private function create_notif_user($for, $notif_id)
    {
        $user = auth()->user();

        if ($for == "all") {

            NotificationUser::create([
                "notification_id" => $notif_id,
                "user_id"         => $user->id,
            ]);
        }

        return true;
    }
}
