<?php

namespace App\Services;

use App\Exceptions\OtpWrongException;
use App\Mail\NotifyEmail;
use App\Mail\NotifyEmailReset;
use App\Models\UserOtp;
use Illuminate\Support\Facades\Mail;

class OtpService
{
    public function addOtpRegist($user_id, $type = UserOtp::VERIFY)
    {
        $set_otp = rand(11111, 99999);

        $otp = $this->checkOtpRegister($user_id, $type) ?? new UserOtp();
        $otp->user_id = $user_id;
        $otp->type    = $type;
        $otp->otp     = $set_otp;
        $otp->save();

        return $set_otp;
    }

    public function addOtpReset($user_id, $type = UserOtp::RESET)
    {
        return $this->addOtpRegist($user_id, $type);
    }

    public function checkOtpVerifyRegist($user_id, $otp, $type = UserOtp::VERIFY)
    {
        $check_otp = UserOtp::where('user_id', $user_id)->where('type', $type)->where('otp', $otp)->first();
        if (!$check_otp) {
            throw new OtpWrongException();
        }
        return $check_otp;
    }

    public function checkOtpVerifyReset($user_id, $otp, $type = UserOtp::RESET)
    {
        return $this->checkOtpVerifyRegist($user_id, $otp, $type);
    }

    public function checkOtpRegister($user_id, $type = UserOtp::VERIFY)
    {
        return UserOtp::where('user_id', $user_id)->where('type', $type)->first();
    }

    public function checkOtpReset($user_id, $type = UserOtp::RESET)
    {
        return $this->checkOtpRegister($user_id, $type);
    }

    public function sendEmailOtpRegist($email, $otp, $type = UserOtp::VERIFY)
    {
        Mail::to($email)->send(new NotifyEmail($otp, $type));
    }

    public function sendEmailOtpReset($email, $user)
    {
        Mail::to($email)->send(new NotifyEmailReset($user));
    }

    public function deleteOtpRegist($user_id, $type = UserOtp::VERIFY)
    {
        $otp = $this->checkOtpRegister($user_id, $type);

        return $otp?->delete();
    }

    public function deleteOtpReset($user_id, $type = UserOtp::RESET)
    {
        return $this->deleteOtpRegist($user_id, $type);
    }
}
