<?php

namespace App\Services;

use App\Http\Requests\ProductRequest;
use App\Http\Requests\ProductUpdateRequest;
use App\Models\{Product, ShoppingItem};
use Carbon\Carbon;
use Illuminate\Support\Str;

class ProductService
{

    public function find($id)
    {
        return Product::with('category', 'unit', 'package')->find($id);
    }

    public function list($request)
    {
        $user = auth()->user();

        $data = Product::withParameters(array_merge($request->toArray(), [
            'id_user' => $user->id
        ]))
        ->orderby('id', 'desc');
        $data = $data->latest()->paginate(10);

        $data->getCollection()->transform(function ($item) {

            $show['id']                  = $item->id;
            $show['id_category_product'] = $item->id_category_product;
            $show['category_product']    = $item->category?->title;
            $show['title']               = $item->title;
            $show['id_unit_product']     = $item->id_unit_product;
            $show['unit_product']        = $item->unit?->title;
            $show['id_package_product']  = $item->id_package_product;
            $show['package_product']     = $item->package?->title;
            $show['sku']                 = $item->sku;

            return $show;
        });

        return $data;
    }

    public function list_po($request)
    {
        $user = auth()->user();

        $id_product = ShoppingItem::with('shopping')->withParameters([
            'id_user' => $user->id,
        ])->groupby('id_product')->pluck('id_product');

        $data = Product::withParameters(array_merge($request->toArray(), [
            'id_user' => $user->id,
            'ids' => $id_product
        ]))
        ->orderby('id', 'desc');
        $data = $data->latest()->paginate(10);

        $data->getCollection()->transform(function ($item) {

            $show['id']                  = $item->id;
            $show['id_category_product'] = $item->id_category_product;
            $show['category_product']    = $item->category?->title;
            $show['title']               = $item->title;
            $show['id_unit_product']     = $item->id_unit_product;
            $show['unit_product']        = $item->unit?->title;
            $show['id_package_product']  = $item->id_package_product;
            $show['package_product']     = $item->package?->title;
            $show['sku']                 = $item->sku;

            return $show;
        });

        return $data;
    }

    public function create(ProductRequest $request)
    {
        $user = auth()->user();

        Product::create(array_merge($request->all(), [
            'id_user' => $user->id,
            'sku'     => $this->get_sku($user)
        ]));

        return true;
    }

    public function update(ProductUpdateRequest $request)
    {
        $find = $this->find($request->id);

        if ($find) {
            $find->update($request->all());
        }

        return true;
        
    }

    public function delete($id)
    {
        $find = $this->find($id);

        if ($find) {
            $find->delete();
        }

        return true;
    }

    public function get_sku($user)
    {
        $_code = $user->code . 'SKU';
        
        $_po = Product::where('id_user', $user->id)->latest()->withTrashed()->first();

        $_id = (int) str_replace($_code, '', $_po?->sku) ?? 0;

        return  $_code . ($_id + 1);
    }

    
}
