<?php

namespace App\Services;

use Illuminate\Support\Arr;
use Illuminate\Support\Facades\File;
use Intervention\Image\Facades\Image;

class UploadService
{

    public function uploadImage($image, $folder, $image_old = null)
    {
        $filename    = time() . "_" . $image->hashName();

        $folder_name = $folder . '/' . $filename;

        $tujuan = config('upload.link') . $folder_name;

        $image_resize = Image::make($image->getRealPath());

        $image_resize->resize(null, 600, function ($constraint) {
            $constraint->aspectRatio();
        });

        $image_resize->save($tujuan);

        if($image_old != null)
        {
            $this->deleteFile($image_old);
        }

        return $folder_name;
    }

    public function deleteFile(array|string $file)
    {
        if (Arr::accessible($file)) {
            $path = collect($file)->map(function ($item) {
                return config('upload.link') . $item;
            });
        } else {
            $path = config('upload.link') . $file;
        }

        return File::delete($path);
    }
}
