<?php

namespace App\Services;

use App\Http\Requests\UserRequest;
use App\Models\{CostItem, POItem, ShoppingItem, User, UserAccount, UserBussines};
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class UserService
{
    public function __construct(
        private UploadService $upload_service,
        private AuthService $auth_service,
    ) {
        $this->upload_service = $upload_service;
        $this->auth_service = $auth_service;
    }

    public function find($id)
    {
        return User::find($id);
    }

    public function find_bussiness($id)
    {
        return UserBussines::find($id);
    }

    public function update(UserRequest $request)
    {
        DB::beginTransaction();

        $user = auth()->user();

        $find = $this->find($user?->id);

        $photo = $request->hasFile('photo') ? $this->upload_service->uploadImage($request->photo, 'user', $user?->profile) : $user?->profile; 
        $ktp   = $request->hasFile('ktp') ? $this->upload_service->uploadImage($request->ktp, 'ktp', $user?->ktp) : $user?->ktp; 
        $npwp  = $request->hasFile('npwp') ? $this->upload_service->uploadImage($request->npwp, 'npwp', $user?->npwp) : $user?->npwp; 

        if ($find) {
            $password = $request->password;
            $find->update([
                'front_name'    => $request->front_name,
                'back_name'     => $request->back_name,
                'nik'           => $request->nik,
                'phone_number'  => $request->phone_number,
                'email'         => $request->email,
                'id_profession' => $request->id_profession,
                'profile'       => $photo,
                'ktp'           => $ktp,
                'npwp'          => $npwp,
                'password'      => !empty($password) ? Hash::make($password) : $find->password,
            ]);

            UserAccount::updateOrCreate([
                'id' => $find->id
            ],
            [
                'id'        => $find->id,
                'branch'    => $request->branch,
                'names'     => $request->names,
                'bank'      => $request->bank,
                'account_number' => $request->account_number,
            ]);

            $find_b = $this->find_bussiness($find?->id);

            if ($find_b) {

                $photo_bussines = $request->hasFile('photo_bussines') ? $this->upload_service->uploadImage($request->photo_bussines, 'photo_bussines', $find_b?->profile_bussines) : $find_b?->profile_bussines; 
                $akta_bussines  = $request->hasFile('akta_bussines') ? $this->upload_service->uploadImage($request->akta_bussines, 'akta_bussines', $find_b?->akta) : $find_b?->akta; 
                $npwp_bussines  = $request->hasFile('npwp_bussines') ? $this->upload_service->uploadImage($request->npwp_bussines, 'npwp_bussines', $find_b?->npwp) : $find_b?->npwp; 
                $nib_bussines   = $request->hasFile('nib_bussines') ? $this->upload_service->uploadImage($request->nib_bussines, 'nib_bussines', $find_b?->nib) : $find_b?->nib; 
                $sk_bussines    = $request->hasFile('sk_bussines') ? $this->upload_service->uploadImage($request->sk_bussines, 'sk_bussines', $find_b?->sk_kemenkum) : $find_b?->sk_kemenkum; 

                $find_b->update([
                    'name_bussines'     => $request->name_bussines,
                    'profile_bussines'  => $photo_bussines,
                    'id_province'       => $request->id_province,
                    'id_city'           => $request->id_city,
                    'id_subdistrict'    => $request->id_subdistrict,
                    'village'           => $request->village,
                    'postcode'          => $request->postcode,
                    'address'           => $request->address,
                    'latitude'          => $request->latitude,
                    'longitude'         => $request->longitude,
                    'rt'                => $request->rt,
                    'rw'                => $request->rw,
                    'akta'              => $akta_bussines,
                    'npwp'              => $npwp_bussines,
                    'nib'               => $nib_bussines,
                    'sk_kemenkum'       => $sk_bussines,
                ]);
            }

        }

        DB::commit();

        return true;
    }

    public function total_benefit($user_id)
    {
        $user = User::with(['saldo', 'approved'])->find($user_id);

        $_percentShare = $user->role == 'Mitra Kerjasama' ? (double) $user->saldo?->share_portion : 0;

        $_initialCapital = $user->role == 'Mitra Kerjasama' ? (double) $user->saldo?->saldo : 0;

        $_totalCapital = $_initialCapital > 0 ? $_initialCapital * $_percentShare : 0;

        $_totalPo   = POItem::withParameters(['id_user' => $user->id])->sum('subtotal');
        $_totalShop = ShoppingItem::withParameters(['id_user' => $user->id])->sum('subtotal');
        $_totalCost = CostItem::withParameters(['id_user' => $user->id])->sum('subtotal');


        switch ($user->role) {
            case 'Mitra Mandiri':
                $total_benefit = $_totalPo - ($_totalShop + $_totalCost);
                break;

            case 'Mitra Kerjasama':
                $total_benefit = ($_totalPo - ($_totalShop + $_totalCost + $_totalCapital)) * $_percentShare;
                break;
            
            default:
                $total_benefit =  0;
                break;
        }

        return [
            'share_portion'     => $_percentShare,
            'total_modal_setor' => $_initialCapital,
            'total_biaya_modal' => $_totalCapital,
            'total_benefit'     => $total_benefit,
        ];
    }

    
}
