<?php

namespace App\Services\Xendit;

use Xendit\EWallets;

class XenditEWalletService
{
    public function ovo(int $total)
    {
        $ovoParams = [
            'external_id' => 'demo-' . time(),
            'amount' => $total,
            'phone' => '081298498259',
            'ewallet_type' => 'OVO'
        ];

        return EWallets::create($ovoParams);
    }

    public function dana(int $total)
    {
        $danaParams = [
            'external_id' => 'demo_' . time(),
            'amount' => $total,
            'phone' => '081298498259',
            'expiration_date' => '2100-02-20T00:00:00.000Z',
            'callback_url' => 'https://my-shop.com/callbacks',
            'redirect_url' => 'https://my-shop.com/home',
            'ewallet_type' => 'DANA'
        ];

        return EWallets::create($danaParams);
    }

    public function linkAja(int $total, array $items)
    {
        $items = [
            [
                'id' => '123123',
                'name' => 'Phone Case',
                'price' => 100000,
                'quantity' => 1
            ],
            [
                'id' => '345678',
                'name' => 'Powerbank',
                'price' => 200000,
                'quantity' => 1
            ]
        ];

        $linkajaParams = [
            'external_id' => 'demo_' . time(),
            'amount' => $total,
            'phone' => '081298498259',
            'items' => $items,
            'callback_url' => 'https =>//yourwebsite.com/callback',
            'redirect_url' => 'https =>//yourwebsite.com/order/123',
            'ewallet_type' => 'LINKAJA'
        ];

        return EWallets::create($linkajaParams);
    }

    public function shoppe(int $total)
    {
        $params = [
            'reference_id' => 'Topup Wakaf',
            'currency' => 'IDR',
            'amount' => $total,
            'checkout_method' => 'ONE_TIME_PAYMENT',
            'channel_code' => 'ID_SHOPEEPAY',
            'channel_properties' => [
                'success_redirect_url' => 'https://api-sampang-collector.serverwan.com/api/topup/nominal',
            ],
            'metadata' => [
                'meta' => 'data'
            ]
        ];
        return EWallets::createEWalletCharge($params);
    }

}
