<?php

use App\Constants\EWalletConstant;
use App\Models\PaymentMethod;
use Carbon\Carbon;
use Illuminate\Support\Str;

if (!function_exists('respondWithToken')) {

    function respondWithToken($token)
    {
        return response()->json([
            'token' => $token,
            'token_type' => 'bearer'
        ], 200);
    }
}

if (!function_exists('responseJson')) {

    function responseJson($response, $http = 200)
    {
        return response()->json($response, $http)
            ->header('Content-Type', 'application/json');
    }
}

if (!function_exists('responseSuccess')) {

    function responseSuccess($body = [], $http = 200)
    {
        if (array_key_exists("status", $body) && array_key_exists("message", $body)) {
            $body = $body;
        } else {
            $body = array_merge(['status' => true, 'message' => 'Success'], $body);
        }

        return responseJson($body, $http);
    }
}

if (!function_exists('responseSuccessPaginate')) {

    function responseSuccessPaginate($body, $http = 200, $array = [])
    {
        $message = ['status' => true, 'message' => 'Success'];
        $body    = is_array($body) ? $body : $body->toArray();
        $body    = array_merge($message, $array, $body);

        return responseJson($body, $http);
    }
}

if (!function_exists('responseNotFound')) {

    function responseNotFound(string $message = 'Data tidak ada', $http = 404)
    {
        return responseJson(['status' => false, 'message' => $message], $http);
    }
}

if (!function_exists('responseError')) {

    function responseError(string $message = 'Error', $http = 500)
    {
        return responseJson(['status' => false, 'message' => $message], $http);
    }
}

if (!function_exists('ValidateIsFile')) {

    function ValidateIsFile($file, $type = 'image', $type_content = 'content')
    {
        if (filter_var($file, FILTER_VALIDATE_URL)) {
            $new_file = $file;
        } else {
            $new_file = config('asset.link') . $file;
        }

        return is_null($file) ? ($type == 'image' ? config('asset.link') . ($type_content == 'user' ? 'user-not-found.png' : 'notfound.png') : null) : $new_file;
    }
}

if (!function_exists('translatedFormat')) {

    function translatedFormat($date, $format = 'd F Y')
    {
        return parseDate($date)->translatedFormat($format);
    }
}

if (!function_exists('parseDate')) {
    function parseDate($date)
    {
        if ($date) {
            return Carbon::parse($date);
        } else {
            return null;
        }
    }
}

if (!function_exists('surahSetting')) {
    function surahSetting()
    {
        $user = auth()?->user();
        return [
            "size_font_arabic" => is_null($user) ? 14 : $user?->size_font_arabic,
            "is_latin" => is_null($user) ? true : ($user?->is_latin == 1 ? true : false),
            "size_font_latin" => is_null($user) ? 14 : $user?->size_font_latin,
            "is_translation" => is_null($user) ? true : ($user?->is_translation == 1 ? true : false),
            "size_font_translation" => is_null($user) ? 14 : $user?->size_font_translation,
        ];
    }
}

if (!function_exists('translatedDaynDate')) {
    function translatedDaynDate($date)
    {
        return parseDate($date)->translatedFormat('l').", ".parseDate($date)->translatedFormat('d F Y');
    }
}

if (!function_exists('translatedDay')) {
    function translatedDay($day)
    {
        switch ($day) {
            case 'Monday':
                return 'Senin';
                break;
            case 'Tuesday':
                return 'Selasa';
                break;
            case 'Wednesday':
                return 'Rabu';
                break;
            case 'Thursday':
                return 'Kamis';
                break;
            case 'Friday':
                return 'Jumat';
                break;
            case 'Saturday':
                return 'Sabtu';
                break;
            case 'Sunday':
                return 'Minggu';
                break;

            default:
                return '-';
                break;
        }
    }
}

if (!function_exists('countDown')) {
    function countDown($due_date, $status, $transaction_type)
    {
        $now = Carbon::now()->toDateString();

        if ($status == 'Lunas') {
            return 0;
        }

        if ($transaction_type == 'tunai') {
            return 0;
        }

        if ($due_date < $now) {
            return 0;
        }

        return Carbon::parse($due_date)->diffInDays(Carbon::parse($now));
    }
}

if (!function_exists('getInvoiceId')) {
    function getInvoiceId(?string $name = "AHMAD")
    {
        $rands = Str::upper(Str::random(5));
        return 'TRS' . strtoupper(Str::slug(substr($name, 0, 2))) . $rands . date('sdmh');
    }
}

if (!function_exists('calculateFee')) {
    function calculateFee(string $bank_code, string $tax_type, int $tax, int $total): int
    {
        switch ($tax_type) {
            case PaymentMethod::PERCENT:

                $tax = round($total * $tax / 100);

                if ($bank_code != EWalletConstant::SHOPEE_PAY) {
                    $fee = $tax * (11 / 100);
                } else {
                    $fee = 0;
                }

                return $tax + round($fee);
                break;
            case PaymentMethod::NOMINAL:

                return $tax + round($tax * (11 / 100));

                break;
        }
    }
}

if (!function_exists('calculateFeeWithoutTax')) {
    function calculateFeeWithoutTax(string $bank_code, string $tax_type, int $tax, int $total): int
    {
        switch ($tax_type) {
            case PaymentMethod::PERCENT:

                if ($bank_code != EWalletConstant::SHOPEE_PAY) {
                    $fee = round($total * $tax / 100);
                } else {
                    $fee = 0;
                }

                return $tax + round($fee);
                break;
            case PaymentMethod::NOMINAL:

                return $tax;

                break;
        }
    }
}

if (!function_exists('expiredDate')) {
    function expiredDate(int $days = 1)
    {
        return now()->addDays($days);
    }
}
