<?php

namespace App\Exceptions;

use Exception;

class UserNotVerifiedException extends Exception
{
    public $email;
    public $otp;
    
    public function __construct($email, $otp)
    {
        $this->email = $email;
        $this->otp = $otp;
    }
    public function render()
    {
        $body = ['status' => false, 
                 'message' => 'Anda belum verifikasi akun!', 
                 'data' => [
                     'email' => $this->email,
                     'otp'   => $this->otp,
                 ], 
                ];

        return responseJson($body, 404);
    }
}
