<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use App\Models\Unit;

class UnitProductExport implements FromCollection, WithTitle, WithCustomStartCell, ShouldAutoSize, WithEvents
{
    public function title(): string
    {
        return 'Satuan Unit';
    }
    public function startCell(): string
    {
        return 'A2';
    }
    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $sheet = $event->sheet;
                

                $sheet->setCellValue('A1', 'Satuan Unit Id');
                $sheet->setCellValue('B1', 'Judul Satuan Unit');


                $cols = array_keys($sheet->getDelegate()->getColumnDimensions());
                foreach ($cols as $col) {
                    $sheet->getDelegate()->getColumnDimension($col)->setAutoSize(true);
                }

                $styleArray = [
                    'font' => [
                        'bold' => true
                    ],
                    'alignment' => [
                        'horizontal' => Alignment::HORIZONTAL_CENTER,
                        'vertical' => Alignment::VERTICAL_CENTER
                    ]
                ];
            },
        ];
    }
    public function collection()
    {
        return Unit::select('id', 'title')->get();
    }
}
