<?php

namespace App\Http\Controllers;

use App\Models\City;
use App\Models\Province;
use App\Models\Subdistrict;
use Illuminate\Http\Request;

class AreaController extends Controller
{
    public function province()
    {
        return responseSuccess([
            'data' => Province::select('province_id', 'province_name')->get()
        ]);
    }

    public function city($province_id)
    {
        return responseSuccess([
            'data' => City::select('city_id', 'city_name', 'postal_code')->where('province_id', $province_id)->get()
        ]);
    }

    public function subdistrict($city_id)
    {
        return responseSuccess([
            'data' => Subdistrict::select('subdistrict_id', 'subdistrict_name')->where('city_id', $city_id)->get()
        ]);
    }
}
