<?php

namespace App\Http\Controllers;

use App\Http\Requests\CostRequest;
use App\Http\Requests\CostUpdateRequest;
use App\Http\Resources\CostResource;
use App\Services\CostService;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Config;

class CostController extends Controller
{
    public function __construct(
        private CostService $cost_service
    ) {
        $this->cost_service = $cost_service;
    }

    public function create(CostRequest $request)
    {
        $this->cost_service->create($request);

        return responseSuccess();
    }

    public function update(CostUpdateRequest $request)
    {
        $this->cost_service->update($request);

        return responseSuccess();
    }

    public function index()
    {
        return responseSuccessPaginate($this->cost_service->list());
    }

    public function detail($id)
    {
        return responseSuccess(['data' => new CostResource($this->cost_service->find($id))]);
    }
    
    public function delete($id)
    {
        $this->cost_service->delete($id);

        return responseSuccess();
    }

    public function historyMonth()
    {
        $_current  = bulan(Carbon::now());
        $_previous = bulan(Carbon::now()->subMonth());

        return responseSuccess(['month' => [$_previous, $_current], 'data' => $this->cost_service->history_month()]);
    }
}
