<?php

namespace App\Http\Controllers;

use App\Exports\Format\ProductTempExport;
use App\Http\Requests\{ProductRequest, ProductUpdateRequest};
use App\Imports\ProductImport;
use App\Services\ProductService;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Excel;

class ProductController extends Controller
{
    public function __construct(
        private ProductService $product_service
    ) {
        $this->product_service = $product_service;
    }

    public function index(Request $request)
    {
        return responseSuccessPaginate($this->product_service->list($request));
    }

    public function indexPO(Request $request)
    {
        return responseSuccessPaginate($this->product_service->list_po($request));
    }

    public function create(ProductRequest $request)
    {
        $this->product_service->create($request);

        return responseSuccess();
    }

    public function update(ProductUpdateRequest $request)
    {
        $this->product_service->update($request);

        return responseSuccess();
    }

    public function delete($id)
    {
        $this->product_service->delete($id);

        return responseSuccess();
    }

    // Export Import Produk
    public function exportTemplateProduct()
    {
        return Excel::download(new ProductTempExport(), 'TemplateProduct-'.Carbon::now()->format('Y-m-d').'.xlsx');
    }

    public function importProduct(Request $reqs)
    {
        try{
            $file = $reqs->file('file');
            Excel::import(new ProductImport, $file);
            return responseSuccess();
        } catch (\Throwable $th) {
            return responseError('data yang dimasukan ada yang tidak sesuai');
            // return responseError('Terjadi Kesalahan Saat Import Data');
        }
    }
}
