<?php

namespace App\Http\Controllers;

use App\Http\Requests\VendorRequest;
use App\Http\Requests\VendorUpdateRequest;
use App\Http\Resources\VendorResource;
use App\Services\VendorService;
use Illuminate\Http\Request;

class VendorController extends Controller
{
    public function __construct(
        private VendorService $vendor_service
    ) {
        $this->vendor_service = $vendor_service;
    }

    public function index(Request $request)
    {
        return responseSuccessPaginate($this->vendor_service->list($request));
    }

    public function detail($id)
    {
        return responseSuccess(['data' => new VendorResource($this->vendor_service->find($id))]);
    }

    public function create(VendorRequest $request)
    {
        $this->vendor_service->create($request);

        return responseSuccess();
    }

    public function update(VendorUpdateRequest $request)
    {
        $this->vendor_service->update($request);

        return responseSuccess();
    }

    public function delete($id)
    {
        $this->vendor_service->delete($id);

        return responseSuccess();
    }
}
