<?php

namespace App\Http\Resources;

use App\Models\PaymentMethod;
use Illuminate\Http\Resources\Json\JsonResource;

class PaymentTaxResource extends JsonResource
{
    private $nominal;

    public function nominal($nominal)
    {
        $this->nominal = $nominal;
        return $this;
    }

    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $data = $this->resource;

        $data['payment_type'] = $this->paymentType;

        $data['tax'] = calculateFee($this->code, $this->tax_type, $this->tax, $this->nominal);

        return $data;
    }
}
