<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Vendor extends Model
{
    use HasFactory, SoftDeletes;
    
    protected $table = 'vendor';
    
    protected $fillable = [
        'id', 'id_user', 'id_vendor_category', 'name_vendor', 'avatar', 'pic', 'phone_number'
    ];

    protected $primaryKey = 'id';

    public $incrementing = false;

    protected $keyType = 'string';

    public function category()
    {
        return $this->belongsTo(Category::class, 'id_vendor_category')->where('type', 'vendor')->withTrashed();
    }

    public function account()
    {
        return $this->belongsTo(VendorAccount::class, 'id', 'id');
    }

    public function address()
    {
        return $this->belongsTo(VendorAddress::class, 'id', 'id');
    }

    public function scopeWithParameters($q, $request)
    {
        if (!empty($request['q'])) {
            $q->where('name_vendor','like','%'.$request['q'].'%');
        }

        if (!empty($request['id_user'])) {
            $q->where('id_user', $request['id_user']);
        }
    }
}
