<?php

namespace App\Services;

use App\Exceptions\OneSignalException;
use Illuminate\Support\Facades\Http;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class OneSignalService
{
    public function request($title, $description, $user_id, ?string $url = '')
    {
        $rest_key = config('onesignal.user.rest_key');
        $app_id   = config('onesignal.user.app_id');
        $app_url  = config('onesignal.user.url_redirect');

        $headers = [
            'Content-Type' => 'application/json; charset=utf-8',
            'Authorization' => "Basic $rest_key"
        ];

        $heading = ["en" => $title];
        $content = ["en" => $description];
        $user = $user_id;

        $fields = [
            'app_id' => $app_id,
            'include_external_user_ids' => $user,
            'channel_for_external_user_ids' => 'push',
            'data' => array("foo" => "bar"),
            'headings' => $heading,
            'contents' => $content,
            'app_url' => $app_url . $url
        ];
        
        // dd(config('onesignal.url'));

        $one_signal_response = Http::withoutVerifying()->withHeaders($headers)->acceptJson()->post(config('onesignal.url'), $fields);

        $status = $one_signal_response->status();

        if ($one_signal_response->failed()) {
            switch ($status) {
                case Response::HTTP_NOT_FOUND:
                    throw new NotFoundHttpException();
                    break;
                default:
                    $message = collect($one_signal_response->body());

                    throw new OneSignalException($status, $message);
                    break;
            }
        }

        $one_signal_data = $one_signal_response->body();

        return collect(json_decode($one_signal_data, true));
    }
}
