<?php

namespace App\Services;

use App\Http\Requests\ProductUpdateRequest;
use App\Http\Requests\VendorRequest;
use App\Http\Requests\VendorUpdateRequest;
use App\Models\{Vendor, VendorAccount, VendorAddress};
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use App\Exceptions\ErrorHandlingException;

class VendorService
{
    public function __construct(
        private UploadService $upload_service,
    ) {
    }
    public function find($id)
    {
        return Vendor::with('account', 'address')->find($id);
    }

    public function list($request)
    {
        $user = auth()->user();

        $data = Vendor::with('category')
        ->withParameters(array_merge($request->toArray(), [
            'id_user' => $user->id
        ]))
        ->orderby('id', 'desc');
        $data = $data->latest()->paginate(10);

        $data->getCollection()->transform(function ($item) {

            $show['id']                 = $item->id;
            $show['name_vendor']        = $item->name_vendor;
            $show['vendor_category']    = $item->category?->title;
            
            return $show;
        });

        return $data;
    }

    public function create(VendorRequest $request)
    {
        DB::beginTransaction();

        $user = auth()->user();

        $avatar = $this->upload_service->uploadImage($request->photo, 'vendor');

        $id = $this->get_id($user);

        $vendor = Vendor::create([
            'id'                => $id,
            'id_user'           => $user->id,
            'id_vendor_category'=> $request->id_vendor_category,
            'name_vendor'   => $request->name_vendor,
            'pic'           => $request->pic,
            'phone_number'  => $request->phone_number,
            'avatar'        => $avatar
        ]);

        VendorAccount::create([
            'id'        => $vendor->id,
            'bank'      => $request->bank,
            'branch'    => $request->branch,
            'names'     => $request->names,
            'account_number' => $request->account_number,
        ]);

        VendorAddress::create([
            'id'            => $vendor->id,
            'id_province'   => $request->id_province,
            'id_city'       => $request->id_city,
            'id_subdistrict'=> $request->id_subdistrict,
            'village'       => $request->village,
            'postcode'      => $request->postcode,
            'address'       => $request->address,
            'rt'            => $request->rt,
            'rw'            => $request->rw,
            'latitude'      => $request->latitude,
            'longitude'     => $request->longitude,
        ]);
        
        DB::commit();

        return true;
    }

    public function update(VendorUpdateRequest $request)
    {
        DB::beginTransaction();
        $find = $this->find($request->id);

        if ($find) {
            $avatar = $request->hasFile('photo') ? $this->upload_service->uploadImage($request->photo, 'vendor') : $find->avatar;

        // $check = Vendor::where('phone_number', $request->phone_number)->where('id', '!=', $find->id)->first();

        // if ($check) {
        //     throw new ErrorHandlingException(422, 'No. Handphone sudah ada yang gunakan');
        // }

        $find->update([
            'id_vendor_category'=> $request->id_vendor_category,
            'name_vendor'   => $request->name_vendor,
            'pic'           => $request->pic,
            'phone_number'  => $request->phone_number,
            'avatar'        => $avatar
        ]);

        VendorAccount::updateOrCreate([
            'id'        => $find->id,
        ],
        [
            'bank'      => $request->bank,
            'branch'    => $request->branch,
            'names'     => $request->names,
            'account_number' => $request->account_number,
        ]);

        VendorAddress::updateOrCreate([
            'id'            => $find->id,
        ],[
            'id_province'   => $request->id_province,
            'id_city'       => $request->id_city,
            'id_subdistrict'=> $request->id_subdistrict,
            'village'       => $request->village,
            'postcode'      => $request->postcode,
            'address'       => $request->address,
            'rt'            => $request->rt,
            'rw'            => $request->rw,
            'latitude'      => $request->latitude,
            'longitude'     => $request->longitude,
        ]);
        }

        DB::commit();

        return true;
        
    }

    public function delete($id)
    {
        $find = $this->find($id);

        if ($find) {
            $find->delete();
        }

        return true;
    }

    private function get_id($user)
    {
        $_vend = Vendor::where('id_user', $user->id)->orderby('id', 'desc')->withTrashed()->first();
        
        $_id = (int) substr($_vend?->id, 16);
        // dd($user);
        return $user->code . 'V' . Carbon::now()->format('my') . ($_id + 1);
    }

    
}
