<?php

declare(strict_types=1);

/*
 * This file is part of PHP CS Fixer.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *     Dariusz Rumiński <dariusz.ruminski@gmail.com>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */

namespace PhpCsFixer\Console\SelfUpdate;

/**
 * @internal
 */
interface GithubClientInterface
{
    /**
     * @return list<array{
     *     name: string,
     *     zipball_url: string,
     *     tarball_url: string,
     *     commit: array{sha: string, url: string},
     * }>
     */
    public function getTags(): array;
}
