const province = document.currentScript.getAttribute('province');
const city = document.currentScript.getAttribute('city');
const subdistrict = document.currentScript.getAttribute('subdistrict');

$(document).ready(function() {
  $(`#id_province`).on('change', function() {
    getCity($(this).val())
  })

  $(`#id_city`).on('change', function() {
    getSubdistrict($(this).val())
  })

  if (province) {
    $.when(getCity(province)).then(function() {
      setTimeout(() => {

        $(`#id_city`).val(city).trigger('change')

        if (city) {
          $.when(getSubdistrict(city)).then(function() {
            setTimeout(() => {
              $(`#id_subdistrict`).val(subdistrict).trigger('change')
            }, 1000);
          });
        }

      }, 1000);
    });
  }

});

const getCity = (province_id) => {
  $.ajax({
    url: `${prefixURL}/area/city`,
    type: 'GET',
    data:{
      province_id
    },
    success: function (e) {
      $("#id_city").empty();
      $("#id_city").append(new Option("- Pilih -", ""));
      e.collection.forEach(item => {
        $("#id_city").append(new Option(item.city_name, item.city_id));
      });
    },
    error: function (e) {
      Swal.close()
      disableClick(false)
      var err = errorCustom(e);
      swalLauncher({message : err})
    }
  });
};

const getSubdistrict = (city_id) => {
  $.ajax({
    url: `${prefixURL}/area/subdistrict`,
    type: 'GET',
    data:{
      city_id
    },
    success: function (e) {
      $("#id_subdistrict").empty();
      $("#id_subdistrict").append(new Option("- Pilih -", ""));
      e.collection.forEach(item => {
        $("#id_subdistrict").append(new Option(item.subdistrict_name, item.subdistrict_id));
      });
    },
    error: function (e) {
      Swal.close()
      disableClick(false)
      var err = errorCustom(e);
      swalLauncher({message : err})
    }
  });
};