const element = document.currentScript.getAttribute('element');

const confirmation = (id, pulihkan = false) => {
  Swal.fire({
    title: 'Anda yakin?',
    text: (element == 'reload-withoutdescription') ? null : "Data yang sudah dihapus tidak bisa dikembalikan!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: pulihkan ? 'Ya, pulihkan' : 'Ya, hapus!',
    cancelButtonText: 'Tidak'
  }).then((result) => {
    if (result.isConfirmed) {
      deleteProduct(id, pulihkan)
    }
  })
}

const deleteProduct = (id) => {
  swalWaiting()
  $.ajax({
    url: $(`.deleteForm-${id}`).attr('action'),
    type: 'POST',
    data:{id},
    success: function (e) {
      Swal.close()
      disableClick(false)
      if (e.success) {
        if(element === 'table'){
          $(`#action-${id}`).html('<span class="badge bg-danger">Data berhasil di hapus! <br />Refresh halaman untuk data terbaru</span>')
          $(`#data-${id}`).css('background', '#dee2e6')

        } else if(element == 'reload-withoutdescription') {
          return location.reload();
        } else {
          $(`#data-${id}`).remove()
          if (e.folder == 'all') {
            $("div[id*=data]").remove();
          }
        }
      } else {
        swalLauncher(e)
      }
    },
    error: function(e) {
      Swal.close()
      disableClick(false)
      var err = errorCustom(e);
      swalLauncher({message : err})
    }
  });
  return false
}
