<?php
function boxDashboard($data){
  return [
    'class' => $data[0],
    'count' => $data[1],
    'title' => $data[2],
    'icon' => $data[3],
    'url' => $data[4],
  ];
}

function hari($data)
{
  $data = date('D', strtotime($data));
  if ($data == 'Mon') {
    return 'Senin';
  } elseif ($data == 'Tue') {
    return 'Selasa';
  } elseif ($data == 'Wed') {
    return 'Rabu';
  } elseif ($data == 'Thu') {
    return 'Kamis';
  } elseif ($data == 'Fri') {
    return "Jum'at";
  } elseif ($data == 'Sat') {
    return 'Sabtu';
  } elseif ($data == 'Sun') {
    return 'Minggu';
  }
}

function bulan($data, $short = null)
{
  $bulan = date('m', strtotime($data));
  if ($bulan == '01') {
    if ($short) {
      return 'Jan';
    }
    return 'Januari';
  } elseif ($bulan == '02') {
    if ($short) {
      return 'Feb';
    }
    return 'Februari';
  } elseif ($bulan == '03') {
    if ($short) {
      return 'Mar';
    }
    return 'Maret';
  } elseif ($bulan == '04') {
    if ($short) {
      return 'Apr';
    }
    return 'April';
  } elseif ($bulan == '05') {
    return 'Mei';
  } elseif ($bulan == '06') {
    if ($short) {
      return 'Jun';
    }
    return 'Juni';
  } elseif ($bulan == '07') {
    if ($short) {
      return 'Jul';
    }
    return 'Juli';
  } elseif ($bulan == '08') {
    if ($short) {
      return 'Agt';
    }
    return 'Agustus';
  } elseif ($bulan == '09') {
    if ($short) {
      return 'Sep';
    }
    return 'September';
  } elseif ($bulan == '10') {
    if ($short) {
      return 'Okt';
    }
    return 'Oktober';
  } elseif ($bulan == '11') {
    if ($short) {
      return 'Nov';
    }
    return 'November';
  } elseif ($bulan == '12') {
    if ($short) {
      return 'Des';
    }
    return 'Desember';
  }
}

function tgl($data, $format = null)
{
  if ($format == 'full') {
    return date('H:i', strtotime($data)) . ', ' . date('d', strtotime($data)) .' '. bulan($data) .' '. date('Y', strtotime($data));
  }
  return  bulan($data) . ' ' . date('d', strtotime($data)) .', '. date('Y', strtotime($data));
}

function search_tgl(){
  return date('Y-m-d', strtotime('- 3 years')).'_-_'.date('Y-m-d');
}

function opacity($data){
  if ($data == 'yes') {
    return null;
  }
  return ' style="opacity: .3"';
}

function active($data){
  if ($data == 'yes') {
    return '<span class="mr-2" style="color:green"><i class="fas fa-eye"></i></span>';
  }
  return '<span class="mr-2" style="color:red"><i class="fas fa-eye-slash"></i></span>';
}

function no($key, $limit = 0){
  return (!empty($_GET['page'])) ? (int) ($limit < 1 ? 10 : $limit) + $key + 1 : $key + 1;
}

function errors($th, $message = null){
  return [
    'code' => 500,
    'success' => false,
    'message' => $message ?? $th->getMessage(),
    'line' => $th->getLine(),
    'file' => $th->getFile()
  ];
}

function timeCalculate($date) {
  $d1 = strtotime($date);
  $d2 = strtotime(date('Y-m-d H:i:s'));
  $totalSecondsDiff = abs($d1-$d2); //42600225
  $totalMinutesDiff = round($totalSecondsDiff/60); //710003.75
  $totalHoursDiff   = round($totalSecondsDiff/60/60);//11833.39
  $totalDaysDiff    = round($totalSecondsDiff/60/60/24); //493.05
  $totalMonthsDiff  = round($totalSecondsDiff/60/60/24/30); //16.43
  $totalYearsDiff   = round($totalSecondsDiff/60/60/24/365); //1.35

  if($totalSecondsDiff <= 60) {
    return $totalSecondsDiff.' Detik lalu';
  } elseif($totalMinutesDiff <= 60) {
    return $totalMinutesDiff.' Menit lalu';
  } elseif($totalHoursDiff <= 24) {
    return $totalHoursDiff.' Jam lalu';
  } elseif($totalDaysDiff <= 31) {
    return $totalDaysDiff.' Hari lalu';
  } elseif($totalMonthsDiff <= 365) {
    return $totalMonthsDiff.' Bulan lalu';
  } else{
    return $totalYearsDiff.' Tahun lalu';
  }
}

function base_url($file = null) {
  if (!$file) {
    return '#';
  }
  return env('URL_ASSET').$file;
}

function _asset($url) {
  $separator = '?';
  $parse = parse_url($url);

  if (!empty($parse['query'])) {
    $separator = '&';
  }

  return asset($url.$separator.'envRand=j238hhku13132');
}
