<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Repositories\AreaRepository;

class AreaController extends Controller
{
    public function __construct(
        private AreaRepository $area,
    ) {
    
    }

    function city(Request $req){
        try {
            return response()->json([
                'code' => 200,
                'success' => true,
                'collection' => $this->area->city($req->province_id)
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'code' => 500,
                'success' => false,
                'message' => $th->getMessage()
            ], 500);
        }
    }

    function subdistrict(Request $req){
        try {
            return response()->json([
                'code' => 200,
                'success' => true,
                'collection' => $this->area->subdistrict($req->city_id)
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'code' => 500,
                'success' => false,
                'message' => $th->getMessage()
            ], 500);
        }
    }
}
