<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\CategoryService;
use App\Repositories\CategoryRepository;

class CategoryController extends Controller
{
  public function __construct(
    private CategoryRepository $repository,
    private CategoryService $service
  ) {
  
  }
  
  function index(Request $req){
    $params = [
      'title' => 'Kategori',
      'collection' => $this->repository->get($req->all())
    ];

    return view('category.index', $params);
  }
  
  function add(){
    $params = [
      'title' => 'Kategori'
    ];

    return view('category.add', $params);
  }
  
  function edit($id){
    $find = $this->repository->find($id);

    if (!$find) {
      return abort(404);
    }

    $params = [
      'title' => 'Kategori',
      'item' => $find,
    ];

    return view('category.edit', $params);
  }
  
  function store(Request $req){
    return $this->service->container($req, 'store');
  }
  
  function update(Request $req){
    return $this->service->container($req, 'update');
  }
  
  function delete(Request $req){
    return $this->service->container($req, 'delete');
  }
}
