<?php

namespace App\Http\Controllers;

use App\Repositories\BankRepository;
use App\Repositories\CategoryRepository;
use App\Repositories\PaymentMethodRepository;
use App\Repositories\PaymentMethodTypeRepository;
use App\Repositories\Product\PackageRepository;
use App\Repositories\Product\UnitRepository;
use App\Repositories\ProfessionRepository;
use App\Repositories\SubscriptionRepository;
use App\Repositories\Venture\VentureRepository;
use App\Repositories\Venture\WithdrawRepository;
use App\Repositories\WithdrawSubscribeRepository;
use Illuminate\Http\Request;

class DashboardController extends Controller
{

  public function __construct(
    private WithdrawSubscribeRepository $revenue,
    private VentureRepository $venture,
    private WithdrawRepository $ventureWithdraw,
    private ProfessionRepository $profession,
    private BankRepository $bank,
    private CategoryRepository $category,
    private SubscriptionRepository $subscription,
    private PaymentMethodRepository $paymentMethod,
    private PaymentMethodTypeRepository $paymentType,
    private PackageRepository $package,
    private UnitRepository $unit,
  ) {
  
  }

  function index(Request $req){
    $params = [
      'box' => [
        'revenue' => $this->revenue->where(['status' => 'success'])->sum('nominal'),
        'venture' => $this->venture->count(),
        'venture_subscribe' => $this->venture->count([
          'subscribe' => true
        ]),
        'venture_unsubscribe' => $this->venture->count([
          'unsubscribe' => true
        ]),
        'venture_withdraw' => $this->ventureWithdraw->sum()
      ],
      'master_data' => [
        'profession' => $this->profession->count(),
        'bank' => $this->bank->count(),
        'category_product' => $this->category->count(['type' => 'product']),
        'category_vendor' => $this->category->count(['type' => 'vendor']),
        'category_pengeluaran' => $this->category->count(['type' => 'pengeluaran']),
        'subscription' => $this->subscription->count(),
        'payment_method' => $this->paymentMethod->count(),
        'payment_type' => $this->paymentType->count(),
        'package' => $this->package->count(),
        'unit' => $this->unit->count(),
      ]
    ];

    if ($req->format == 'json') {
      return $params;
    }

    return view('dashboard', $params);
  }
}
