<?php

namespace App\Http\Controllers\Opex;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Repositories\Opex\PengeluaranRepository;

class PengeluaranController extends Controller
{
    public function __construct(
        private PengeluaranRepository $repository,
    ) {
    
    }
    
    function index(Request $req){
        $params = [
            'title' => 'Pengeluaran',
            'collection' => $this->repository->get($req->all())
        ];
        return view('opex.pengeluaran.index', $params);
    }
    
    function find($id){
        $find = $this->repository->findWithRelation($id);
    
        if (!$find) {
            return(abort(404));
        }
    
        $params = [
            'title' => 'Pengeluaran',
            'item' => $find
        ];
        return view('opex.pengeluaran.find', $params);
    }
    
}
