<?php

namespace App\Http\Controllers;

use App\Repositories\PaymentMethodTypeRepository;
use App\Services\PaymentMethodTypeService;
use Illuminate\Http\Request;

class PaymentMethodTypeController extends Controller
{
    public function __construct(
        private PaymentMethodTypeRepository $repository,
        private PaymentMethodTypeService $service
    ) {
    
    }
    
    function index(Request $req){
        $params = [
            'title' => 'Tipe Metode Pembayaran',
            'collection' => $this->repository->get($req->all())
        ];
        return view('payment-method-type.index', $params);
    }

    function edit($id){
        $find = $this->repository->find($id);
    
        if (!$find) {
            return abort(404);
        }
    
        $params = [
            'title' => 'Tipe Metode Pembayaran',
            'item' => $find,
        ];
        return view('payment-method-type.edit', $params);
    }

    function update(Request $req){
        return $this->service->container($req, 'update');
    }
    
    function delete(Request $req){
        return $this->service->container($req, 'delete');
    }
}
