<?php

namespace App\Http\Controllers\Product;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Repositories\CategoryRepository;
use App\Repositories\Product\PackageRepository;
use App\Services\Product\ProductService;
use App\Repositories\Product\ProductRepository;
use App\Repositories\Product\UnitRepository;

class ProductController extends Controller
{
  public function __construct(
    private ProductRepository $repository,
    private CategoryRepository $category,
    private PackageRepository $package,
    private UnitRepository $unit,
    private ProductService $service
  ) {
  
  }
  
  function index(Request $req){
    $params = [
      'title' => 'Daftar Produk',
      'collection' => $this->repository->get($req->all())
    ];
    return view('product.list.index', $params);
  }
  
  function find($id){
    $find = $this->repository->findWithRelation($id);

    if (!$find) {
      return abort(404);
    }

    return view('product.list.find', [
      'title' => 'Daftar Produk',
      'item' => $find
    ]);
  }

  /*
  function add(){
    $params = [
      'title' => 'Daftar Produk',
      'categories' => $this->category->get(['type' => 'product']),
      'packages' => $this->package->get(),
      'units' => $this->unit->get(),
    ];
    return view('product.list.add', $params);
  }
  
  function edit($id){
    $params = [
      'title' => 'Daftar Produk',
      'item' => $this->repository->find($id),
      'categories' => $this->category->get(['type' => 'product']),
      'packages' => $this->package->get(),
      'units' => $this->unit->get(),
    ];
    return view('product.list.edit', $params);
  }
  
  function store(Request $req){
    return $this->service->container($req, 'store');
  }
  
  function update(Request $req){
    return $this->service->container($req, 'update');
  }
  
  function delete(Request $req){
    return $this->service->container($req, 'delete');
  }
  */
}
