<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\ProfessionService;
use App\Repositories\ProfessionRepository;

class ProfessionController extends Controller
{
    public function __construct(
        private ProfessionRepository $repository,
        private ProfessionService $service
    ) {
    
    }
    
    function index(Request $req){
        $params = [
            'title' => 'Profesi',
            'collection' => $this->repository->get($req->all())
        ];
        return view('profession.index', $params);
    }
    
    function add(){
        $params = [
            'title' => 'Profesi'
        ];
        return view('profession.add', $params);
    }
    
    function edit($id){
        $find = $this->repository->find($id);

        if (!$find) {
            return abort(404);
        }

        $params = [
            'title' => 'Profesi',
            'item' => $find,
        ];
        
        return view('profession.edit', $params);
    }
    
    function store(Request $req){
        return $this->service->container($req, 'store');
    }
    
    function update(Request $req){
        return $this->service->container($req, 'update');
    }
    
    function delete(Request $req){
        return $this->service->container($req, 'delete');
    }
}
