<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Configuration;
use App\Repositories\AreaRepository;
use App\Services\Venture\VentureService;
use App\Repositories\ProfessionRepository;
use App\Repositories\Venture\SubscriptionRepository;
use App\Repositories\Venture\WalletRepository;
use App\Repositories\Venture\VentureRepository;

class VentureController extends Controller
{
    public function __construct(
        private VentureRepository $repository,
        private ProfessionRepository $profession,
        private AreaRepository $area,
        private WalletRepository $wallet,
        private SubscriptionRepository $subscription,
        private VentureService $service,
    ) {
    
    }
    
    function index(Request $req){
        $params = [
            'title' => 'WE-HUB Venture',
            'collection' => $this->repository->get($req->all())
        ];
        return view('venture.user.index', $params);
    }

    function find($id){
        $item = $this->repository->findWithRelation($id);

        if (!$item) {
            return abort(404);
        }

        $params = [
            'title' => 'WE-HUB Venture',
            'item' => $item,
            'configuration' => Configuration::first()
        ];
        return view('venture.user.find', $params);
    }

    function cooperation($id){
        $item = $this->repository->user($id);

        if (!$item || $item->role != 'Mitra Kerjasama') {
            return abort(404);
        }

        $params = [
            'title' => 'WE-HUB Venture',
            'item' => $item,
            'configuration' => Configuration::first()
        ];
        return view('venture.user.cooperation', $params);
    }
    
    function _verification(Request $req){
        return $this->service->container($req, 'verification');
    }

    function _cooperation(Request $req){
        return $this->service->container($req, 'cooperation');
    }

    function delete(Request $req){
        return $this->service->container($req, 'delete');
    }

    /**
     * WALLET USER
     * bottom script - wallet page/action
     */
    
    function wallet(Request $req, $id){
        $e = $this->repository->user($id);

        if (!$e || $e->role != 'Mitra Kerjasama') {
            return abort(404);
        }

        $collection = $this->wallet->get([
            'user_id' => $id,
            'periode' => $req->periode ?? bulan(date('Y-m-d'))
        ]);

        $params = [
            'title' => 'WE-HUB Venture',
            'e' => $e,
            'collection' => $collection,
            'total' => $collection->sum('result')
        ];
        return view('venture.user.wallet', $params);
    }

    function _wallet(Request $req){
        return $this->service->container($req, 'wallet');
    }

    /**
     * SALDO USER
     * bottom script - saldo page/action
     */

    function saldo($id){
        $item = $this->repository->user($id);

        if (!$item || $item->role != 'Mitra Kerjasama') {
            return abort(404);
        }

        $params = [
            'title' => 'WE-HUB Venture',
            'item' => $item,
            'configuration' => Configuration::first()
        ];
        return view('venture.user.saldo', $params);
    }

    function _saldo(Request $req){
        return $this->service->container($req, 'saldo');
    }

    /**
     * SUBSCRIPTION USER
     * bottom script - subscription page/action
     */

    function subscription(Request $req){
        $params = [
            'title' => 'WE-HUB Langganan',
            'collection' => $this->subscription->get($req->all())
        ];
        return view('venture.subscription.index', $params);
    }

    /**
     * API USER
     */

    function getUser(Request $req){
        return $this->repository->search([
            'name' => $req->term
        ]);
    }

    /*
    function add(){
        $params = [
            'title' => 'WE-HUB Venture'
        ];
        return view('venture.user.add', $params);
    }
    
    function edit($id){
        $item = $this->repository->findWithRelation($id);

        if (!$item) {
            return abort(404);
        }

        $params = [
            'title' => 'WE-HUB Venture',
            'item' => $item
        ];
        return view('venture.user.edit', $params);
    }
    
    function store(Request $req){
        return $this->service->container($req, 'store');
    }
    
    function update(Request $req){
        return $this->service->container($req, 'update');
    }
    */
}
