<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Repositories\Venture\WithdrawRepository;
use App\Services\Venture\WithdrawService;

class WithdrawController extends Controller
{
    public function __construct(
        private WithdrawRepository $repository,
        private WithdrawService $service
    ) {
    
    }
    
    function index(Request $req){
        $params = [
            'title' => 'Tarik Dana',
            'collection' => $this->repository->get($req->all())
        ];
        return view('venture.withdraw.index', $params);
    }
    
    function handle($id){
        $find = $this->repository->findWithRelation($id);
    
        if (!$find) {
            return(abort(404));
        }
        
        if ($find->status != 'pending') {
            return(abort(404));
        }
    
        $params = [
            'title' => 'Tarik Dana',
            'item' => $find
        ];
        return view('venture.withdraw.handle', $params);
    }

    function _handle(Request $req){
        return $this->service->container($req, 'handle');
    }
    
}
