<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Configuration extends Model
{
  use HasFactory;

  protected $table = 'configuration';

  protected $fillable = [
    'title', 
    'meta_keyword', 
    'meta_description', 
    'description', 
    'web_icon', 
    'mark_icon',
    'account_number',
    'account_name',
    'account_bank',
    'email_getotp',
    'otp_withdraw',
  ];

  function bank(){
    return $this->belongsTo(PaymentMethod::class, 'account_bank');
  }
}
